program define figure4_dynan

* appreciation over the boom; by state; for large states

  clear all
  global mydate = subinstr("${S_DATE}"," ","-",.)
  capture log close
  quietly log using logfiles/figure4_dynan_$mydate, replace
  set more off

* this dataset is generated by make_bpea_data.do

  use bpea_data
  sort persid yr

* for test purposes
* drop if _n > 10000

* exotic LTV measure
* take house value back to its 2000 value and then grow it forward by the change in the
* CPI ex shelter from Haver (UIXHS@CPIDATA), i.e. the average 2007 value divided by
* the average 2000 value.

  gen althsval = (hsval/(1+(z7state_hpi/100)))*(196.6/165.7)
  gen altmort_to_hv = mort_bal_amt/althsval

* scatters first

  save tempdat, replace

  drop if yr~=2007
  sort state
  by state:  gen state_N = _N
  drop if mort_to_hv == 0 | mort_to_hv ==. 
  drop if state_N < 30
 
  collapse (median) med_mort_to_hv    = mort_to_hv    ///
                    med_altmort_to_hv = altmort_to_hv ///
                    med_mort_to_y  = mort_to_y  ///
                    med_zhpi = zboom_state_hpi  ///
                    state_pop = state_pop           ///
		    (p80)   p80_mort_to_hv = mort_to_hv ///
                    p80_altmort_to_hv = altmort_to_hv ///
                    p80_mort_to_y  = mort_to_y  ///
            (p90)   p90_mort_to_hv = mort_to_hv ///
                    p90_altmort_to_hv = altmort_to_hv ///
                    p90_mort_to_y  = mort_to_y  ///
                    [w=wgt], by(state)

  sort med_zhpi
  list med_mort_to_hv med_altmort_to_hv med_zhpi state
  list p80_mort_to_hv p80_altmort_to_hv med_zhpi state
  list p90_mort_to_hv p90_altmort_to_hv med_zhpi state

  local t1 "Mortgage Leverage at Median"
  local t2 "Mortgage Leverage at 80th Percentile"
  local t3 "Mortgage Leverage at 90th Percentile"
  local s1 "Actual"
  local s2 "Actual"
  local s3 "Actual"

  local t4 "Mortgage Leverage at Median"
  local t5 "Mortgage Leverage at 80th Percentile"
  local t6 "Mortgage Leverage at 90th Percentile"
  local s4 "Assuming Home Prices Fall*"
  local s5 "Assuming Home Prices Fall*"
  local s6 "Assuming Home Prices Fall*"

  local l1 "Mortgage Leverage (P50 for State)"
  local l2 "Mortgage Leverage (P80 for State)"
  local l3 "Mortgage Leverage (P90 for State)"
  local l4 "Mortgage Leverage (P50 for State)"
  local l5 "Mortgage Leverage (P80 for State)"
  local l6 "Mortgage Leverage (P90 for State)"

  local nnn = 1
  foreach vvv in mort_to_hv altmort_to_hv {
    foreach sss in med p80 p90 {
      scatter `sss'_`vvv' med_zhpi [w=state_pop], ///
          msymbol(Oh) ///
		  title("`t`nnn''", color(black)) ///
		  subtitle("`s`nnn''") ///
		  xtitle("Percent Change in State Home Prices, 2000-2006",size(medlarge)) ///
              graphregion(margin(vsmall) color(white)) bgcolor(white) /// 
              yscale(range(.2 1.8)) ylabel(.2(.4)1.8,grid) ///
              yline(1, lcolor(black) lpat(dash)) ///
		  ytitle("`l`nnn''") 
      graph save graphs/scat_`sss'_`vvv', replace
      graph export graphs/scat_`sss'_`vvv'.emf, replace
      local nnn = `nnn' + 1
  }
  }
  
  use tempdat, clear

capture log close

end
